#include <iostream>

using namespace std;

long long inversions(vector<double>& a, vector<double>& b, int l, int r) {
	if (l>=r) return 0;
	int m=l+(r-l)/2;
	long long num=0;
	num+=inversions(a, b, l, m);
	num+=inversions(a, b, m+1, r);
	int pl=l;
	int pd=m+1;
	int pb=0;
	while (pl<=m && pd<=r) {
		if (a[pl]<=a[pd])
			b[pb++]=a[pl++];
		else {
			num+=m-pl+1;
			b[pb++]=a[pd++];
		}
	}
	while (pl<=m) b[pb++]=a[pl++];
	while (pd<=r) b[pb++]=a[pd++];
	copy(begin(b), next(begin(b), r-l+1), next(begin(a), l));
	return num;
}

long long inversions(pair<long long, long long> xv[], double t, int n) {
	vector<double> a(n);
	for (int i=0; i<n; i++) a[i]=xv[i].first+t*xv[i].second;
	vector<double> tmp1(a.size()), tmp2(a.size());
	copy(begin(a), end(a), begin(tmp1));
	return inversions(tmp1, tmp2, 0, n-1);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
	int n,k;
	cin>>n>>k;
	pair<long long, long long> xv[n];
	for (int i=0; i<n; i++) {
		int x,v;
		cin>>x>>v;
		xv[i]=make_pair(x,v);
	}
	sort(xv, xv+n);
	double l=0;
	double r=1000000000;
	double m;
	double dm=0.000001;
	while (r-l>dm) {
		m=l+(r-l)/2.0;
		long long inv = inversions(xv, m, n);
		if (inv==k) {
			long long inv = inversions(xv, m-dm, n);
			if (inv!=k) {
				cout<<m-dm;
				return 0;
			}
			else {
				r=m;
			}
		}
		if (inv<k) l=m;
		if (inv>k) r=m;
	}
	cout<<m+dm;
	return 0;
}